% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_genes.R
\name{get_genes}
\alias{get_genes}
\title{Get Genes}
\usage{
get_genes(
  geneIds,
  gencodeVersion = "v26",
  genomeBuild = "GRCh38/hg38",
  page = 0,
  itemsPerPage = 250
)
}
\arguments{
\item{geneIds}{A character vector of gene symbols, versioned gencodeIds, or
unversioned gencodeIds.}

\item{gencodeVersion}{String (default = "v26"). GENCODE annotation release.
Either "v26" or "v19".}

\item{genomeBuild}{String. Options: "GRCh38/hg38", "GRCh37/hg19". Default =
"GRCh38/hg38".}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250).}
}
\value{
A tibble
}
\description{
This service returns information about reference genes. A genome
build and GENCODE version must be provided.
\itemize{
\item Genes are searchable by gene symbol, GENCODE ID and versioned GENCODE ID.
\item Versioned GENCODE ID is recommended to ensure unique ID matching.
\item By default, this service queries the genome build and GENCODE version used by the latest GTEx release.
}

\href{https://gtexportal.org/api/v2/redoc#tag/Reference-Genome-Endpoints/operation/get_genes_api_v2_reference_gene_get}{GTEx API Portal documentation}
}
\examples{
\dontrun{
get_genes(c("CRP", "IL6R"))
}
}
\seealso{
Other Reference Genome Endpoints: 
\code{\link{get_exons}()},
\code{\link{get_gene_search}()},
\code{\link{get_genomic_features}()},
\code{\link{get_gwas_catalog_by_location}()},
\code{\link{get_neighbor_gene}()},
\code{\link{get_transcripts}()}
}
\concept{Reference Genome Endpoints}
