% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_raw_snp}
\alias{plot_raw_snp}
\title{Plot raw SNP}
\usage{
plot_raw_snp(raw, n = 1L, transf = "log", pn = 2, theta = "atan2",
  nan = 0.5)
}
\arguments{
\item{raw}{Raw data object.}

\item{n}{Integer, which SNP should be plotted.}

\item{transf}{Method for transformation of the raw values. "none", "log" and "fourth-root" are implemented.}

\item{pn}{Numeric, p-norm for the intensity calculation.}

\item{theta}{Method for calculation of theta. Currently only "atan2" is implemented.}

\item{nan}{Numveric to replace NaN for ballele computation (division by zero).}
}
\description{
Plots raw data for specified SNP.
}
\examples{
if(require(brassicaData)){
data("raw_napus", package = "brassicaData", envir = environment())
plot_raw_snp(raw_napus)
}
}

