% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{irrelevance_threshold}
\alias{irrelevance_threshold}
\title{Irrelevance threshold for optimal transport sensitivity indices}
\usage{
irrelevance_threshold(
  y,
  M,
  dummy_optns = NULL,
  cost = "L2",
  discrete_out = FALSE,
  solver = "sinkhorn",
  solver_optns = NULL,
  scaling = TRUE
)
}
\arguments{
\item{y}{An array or a matrix containing the output values.}

\item{M}{A scalar representing the number of partitions for continuous
inputs.}

\item{dummy_optns}{(default \code{NULL}) A list containing the options on the
distribution of the dummy variable. See \code{details} for more information.}

\item{cost}{(default \code{"L2"}) A string or function defining the cost function
of the Optimal Transport problem. It should be "L2" or a function taking as
input y and returning a cost matrix. If \code{cost="L2"}, \code{ot_indices} uses the
squared Euclidean metric.}

\item{discrete_out}{(default \code{FALSE}) Logical, by default the output sample
in \code{y} are equally weighted. If \code{discrete_out=TRUE}, the function tries to
create an histogram of the realizations and to use the histogram as
weights. It works if the output is discrete or mixed and the number of
realizations is large. The advantage of this option is to reduce the
dimension of the cost matrix.}

\item{solver}{Solver for the Optimal Transport problem. Currently supported
options are:
\itemize{
\item \code{"1d"}, the one-dimensional analytic solution.
\item \code{"wasserstein-bures"}, the Wasserstein-Bures solution.
\item \code{"sinkhorn"} (default), the Sinkhorn's solver \insertCite{cuturi2013sinkhorn}{gsaot}.
\item \code{"sinkhorn_log"}, the Sinkhorn's solver in log scale \insertCite{peyre2019computational}{gsaot}.
\item \code{"transport"}, a solver of the non regularized OT problem using \code{\link[transport:transport]{transport::transport()}}.
}}

\item{solver_optns}{(optional) A list containing the options for the Optimal
Transport solver. See details for allowed options and default ones.}

\item{scaling}{(default \code{TRUE}) Logical that sets whether or not to scale the
cost matrix.}
}
\value{
An object of class \code{gsaot_indices}.
}
\description{
Calculate irrelevance threshold using dummy variable for Optimal Transport sensitivity indices
}
\details{
The function allows the computation of irrelevance threshold.
The function samples from a distribution defined in
\code{dummy_optns} (by default a standard normal), independent from the output
\code{y} and then computes the indices using the algorithm specified in
\code{solver}. Under the hood, \code{lower_bound} calls the other available functions
in the package:
\itemize{
\item \code{\link[=ot_indices_1d]{ot_indices_1d()}} (for \code{solver="1d"})
\item \code{\link[=ot_indices_wb]{ot_indices_wb()}} (for \code{solver="wasserstein-bures"})
\item \code{\link[=ot_indices]{ot_indices()}} (for \code{solver \%in\% c("sinkhorn", "sinkhorn_log", "wasserstein")})
The user can choose the distribution of the dummy variable using the
argument \code{dummy_optns}. \code{dummy_optns} should be a named list with at least
a term called \code{"distr"} defining the sampling function. The other terms in
the list are used as arguments to the sampling function.
}
}
\examples{
N <- 1000

mx <- c(1, 1, 1)
Sigmax <- matrix(data = c(1, 0.5, 0.5, 0.5, 1, 0.5, 0.5, 0.5, 1), nrow = 3)

x1 <- rnorm(N)
x2 <- rnorm(N)
x3 <- rnorm(N)

x <- cbind(x1, x2, x3)
x <- mx + x \%*\% chol(Sigmax)

A <- matrix(data = c(4, -2, 1, 2, 5, -1), nrow = 2, byrow = TRUE)
y <- t(A \%*\% t(x))

M <- 25

dummy_lb <- irrelevance_threshold(y, M)

# Custom sampling funtion and network simplex solver
dummy_optns <- list(distr = "rgamma", shape = 3)
dummy_lb_cust <- irrelevance_threshold(y, M,
                                      dummy_optns = dummy_optns,
                                      solver = "transport")
}
