% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{gam_mod}
\alias{gam_mod}
\title{generalized additive model}
\usage{
gam_mod(data, resp_scale = "", m.candidates)
}
\arguments{
\item{data}{data containing all necessary columns to run the model}

\item{resp_scale}{Character. Specifies how the response variable is treated in the model.
\itemize{
  \item \strong{"resp_gaussian"}: Uses the response on its original scale, assuming a Gaussian distribution with an identity link (no transformation applied).
  \item \strong{"resp_log"}: Log-transforms the response before modelling. The transformed response is then assumed to follow a Gaussian distribution with an identity link.
  \item \strong{"resp_gamma"}: Keeps the response on its original scale, fitted under a Gamma distribution with a log link. Suitable for strictly positive and right-skewed data.
}}

\item{m.candidates}{the list of candidate equations.}
}
\value{
list including model, fitting statistics, ptable, stable and prediction table
}
\description{
generalized additive model that captures non-linear relationships between a response variable and predictors using smooth functions, while allowing inclusion of random effects or complex structures.
}
\details{
This function models the generalized additive model using mcgv::gam.

If users specify multiple candidate models through the m.candidates argument, the function will fit each candidate model using the maximum likelihood (ML) method.
The corrected Akaike Information Criterion (AICc) will then be compared to determine the best-fitting model. Once the optimal model is identified,
it will be refitted using the restricted maximum likelihood (REML) method and output the results.

If users specify only 1 candidate model through the m.candidates argument, the model is fitted with "REML" method.
}
\examples{

# loading processed data
dt.samples_trt <- readRDS(system.file("extdata", "dt.samples_trt.rds", package = "growthTrendR"))
# pre-data for model
dt.samples_long <- prepare_samples_clim(dt.samples_trt)
dt.samples_long$uid_site.fac <- as.factor(as.character(dt.samples_long$uid_site))
dt.m <- dt.samples_long

# gam_mod
m.gam <-gam_mod(data = dt.m, resp_scale = "resp_log",
                                       m.candidates = c( "rw_mm ~ s(year, by = uid_site.fac)",
                                                         "rw_mm ~ year:uid_site.fac"))
}
