% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{CFS_mapping}
\alias{CFS_mapping}
\title{Interpolate and Map Tree-Ring Data}
\usage{
CFS_mapping(
  data,
  year.span = c(1801, 2017),
  extent.lim = NULL,
  grid.step = 0.1,
  by.spc = FALSE
)
}
\arguments{
\item{data}{input in wide format.}

\item{year.span}{Numeric vector of length 2 giving the range of years to include.}

\item{extent.lim}{Optional numeric vector defining the spatial extent
(\code{c(xmin, xmax, ymin, ymax)}). If \code{NULL}, the extent is
determined from the input data.}

\item{grid.step}{Numeric value specifying the grid spacing in degrees.}

\item{by.spc}{Logical; if \code{TRUE}, maps are generated by species;
if \code{FALSE}, all species are combined.}
}
\value{
An object of class \code{cfs_map}, a list of interpolated raster layers
  by species and year.
}
\description{
This function performs inverse distance weighting (IDW) interpolation
of tree-ring data across a spatial grid, either for all species combined
or by individual species. It generates yearly interpolated raster maps
over a user-defined extent or the extent of the input data.
}
\examples{

\donttest{
# loading processed data
dt.samples_trt <- readRDS(system.file("extdata", "dt.samples_trt.rds", package = "growthTrendR"))
cols.meta = c("uid_tree", "uid_site", "longitude", "latitude", "species")
dt.mapping <- dt.samples_trt$tr_all_wide[
  , c(..cols.meta, as.character(1991:1995)), with = FALSE]
results_mapping <- CFS_mapping(dt.mapping, year.span = c(1991:1993))
}

}
