#' Payday cognitive attention experiment
#'
#' This dataset provides individual-level information from a randomized experiment
#' studying the effect of poverty on cognitive performance. Low-income participants
#' were randomly assigned to take a cognitive test either before or after payday.
#' The outcome measures the number of correct answers on a test designed to assess
#' cognitive ability. The data includes pre-treatment characteristics such as age,
#' income, education, and other demographic variables.
#'
#' Original data licensed under Creative Commons Attribution 4.0 (CC BY 4.0).
#' This version has been lightly processed for demonstration purposes.
#'
#' @format A data frame containing outcomes and pre-treatment
#' characteristics for each participant.
#'
#' @source American Economic Association replication archive.
#' (Carvalho et al., 2016, and Farbmacher et al., 2021)
#'
#' @references
#' Carvalho, Leandro S., Stephan Meier, and Stephanie W. Wang.
#' "Poverty and economic decision-making: Evidence from changes in financial resources at payday."
#' American Economic Review 106, no. 2 (2016): 260-84.
#'
#' Farbmacher, Helmut, Heinrich Kögel, and Martin Spindler.
#' "Heterogeneous effects of poverty on attention."
#' Labour Economics 71 (2021): 102028.
"attentionrct"

#' Brazilian high school financial education RCT
#'
#' This dataset provides student-level information from a randomized controlled trial
#' evaluating the effect of a high school financial education program in Brazil.
#' Schools were randomly assigned to the program, and post-treatment financial literacy
#' was measured.
#' The data includes information on student outcomes and a variety of pre-treatment
#' characteristics such as survey responses and indices measuring students' ability
#' to save and their financial autonomy.
#'
#' Original data licensed under Creative Commons Attribution 4.0 (CC BY 4.0).
#' This version has been lightly processed for demonstration purposes.
#'
#' @format A data frame containing outcomes and pre-treatment
#' characteristics for each student.
#'
#' @source American Economic Association replication archive
#' (Bruhn et al., 2016).
#'
#' @references
#' Bruhn, Miriam, Luciana de Souza Leão, Arianna Legovini, Rogelio Marchetti, and Bilal Zia.
#' "The impact of high school financial education: Evidence from a large-scale evaluation in Brazil."
#' American Economic Journal: Applied Economics 8, no. 4 (2016).
"schoolrct"
