% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_forest.R
\name{predict.quantile_forest}
\alias{predict.quantile_forest}
\title{Predict with a quantile forest}
\usage{
\method{predict}{quantile_forest}(object, newdata = NULL, quantiles = NULL, num.threads = NULL, ...)
}
\arguments{
\item{object}{The trained forest.}

\item{newdata}{Points at which predictions should be made. If NULL, makes out-of-bag
predictions on the training set instead (i.e., provides predictions at
Xi using only trees that did not use the i-th training example). Note
that this matrix should have the number of columns as the training
matrix, and that the columns must appear in the same order.}

\item{quantiles}{Vector of quantiles at which estimates are required. If NULL, the quantiles
used to train the forest is used. Default is NULL.}

\item{num.threads}{Number of threads used in prediction. If set to NULL, the software
automatically selects an appropriate amount.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A list with elements `predictions`: a matrix with predictions at each test point for each desired quantile.
}
\description{
Gets estimates of the conditional quantiles of Y given X using a trained forest.
}
\examples{
\donttest{
# Train a quantile forest.
n <- 50
p <- 10
X <- matrix(rnorm(n * p), n, p)
Y <- X[, 1] * rnorm(n)
q.forest <- quantile_forest(X, Y, quantiles = c(0.1, 0.5, 0.9))

# Predict on out-of-bag training samples.
q.pred <- predict(q.forest)

# Predict using the forest.
X.test <- matrix(0, 101, p)
X.test[, 1] <- seq(-2, 2, length.out = 101)
q.pred <- predict(q.forest, X.test)
}

}
