% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_classes.R, R/aaa_methods.R, R/graphpcor.R
\docType{class}
\name{graphpcor-class}
\alias{graphpcor-class}
\alias{graphpcor}
\alias{graphpcor.formula}
\alias{graphpcor.matrix}
\alias{print.graphpcor}
\alias{summary.graphpcor}
\alias{dim.graphpcor}
\alias{edges,graphpcor-method}
\alias{plot,graphpcor,ANY-method}
\alias{Laplacian.graphpcor}
\alias{vcov,graphpcor-method}
\alias{prec.graphpcor}
\alias{cgeneric.graphpcor}
\alias{cgeneric.matrix}
\title{graphpcor: correlation from nodes and edges}
\usage{
graphpcor(...)

\method{graphpcor}{formula}(...)

\method{graphpcor}{matrix}(...)

\method{print}{graphpcor}(x, ...)

\method{summary}{graphpcor}(object, ...)

\method{dim}{graphpcor}(x, ...)

\S4method{edges}{graphpcor}(object, which, ...)

\S4method{plot}{graphpcor,ANY}(x, y, ...)

\method{Laplacian}{graphpcor}(x)

\S4method{vcov}{graphpcor}(object, ...)

\method{prec}{graphpcor}(model, ...)

\method{cgeneric}{graphpcor}(model, ...)

\method{cgeneric}{matrix}(model, ...)
}
\arguments{
\item{...}{a list of arguments}

\item{x}{graphpcor}

\item{object}{graphpcor object}

\item{which}{not used}

\item{y}{not used}

\item{model}{graphpcor model object}
}
\value{
a \code{graphpcor} object
}
\description{
A graphpcor is a graph where
a node represents a variable and an edge
represent a conditional distribution.
The correlation built from a \code{graphpcor} consider
the parameters for the Cholesky of a precision matrix,
whose non-zero pattern is given from the graph.
}
\section{Methods (by generic)}{
\itemize{
\item \code{edges(graphpcor)}: Extract the edges of a \code{graphcor} to be used for plot

\item \code{plot(x = graphpcor, y = ANY)}: The plot method for \code{graphpcor}

\item \code{vcov(graphpcor)}: The \code{vcov} method for a \code{graphpcor}

}}
\section{Functions}{
\itemize{
\item \code{graphpcor()}: The \code{graphpcor} generic method for \linkS4class{graphpcor}

\item \code{graphpcor(formula)}: Each term to represent a node, and
each \code{~} to represent an edge.

\item \code{graphpcor(matrix)}: Build a \code{graphpcor} from a matrix

\item \code{print(graphpcor)}: The print method for \code{graphpcor}

\item \code{summary(graphpcor)}: The summary method for \code{graphpcor}

\item \code{dim(graphpcor)}: The dim method for \code{graphpcor}

\item \code{Laplacian(graphpcor)}: The Laplacian method for a \code{graphpcor}

\item \code{prec(graphpcor)}: The precision method for 'graphpcor'

\item \code{cgeneric(graphpcor)}: The \code{cgeneric} method for \code{graphpcor} uses \code{\link[=cgeneric_graphpcor]{cgeneric_graphpcor()}}

\item \code{cgeneric(matrix)}: The \code{cgeneric} method for \code{matrix} uses \code{\link[=cgeneric_graphpcor]{cgeneric_graphpcor()}}

}}
\examples{
library(graphpcor)

par(mfrow = c(2, 3), mar = c(0,0,0,0))
plot(graphpcor(x~y+v, z~y+v))
plot(graphpcor(x~y,x~v,z~y,z~v))
plot(graphpcor(x~y, v~x, y~z, z~v))
plot(graphpcor(y~x, v~x, z~y, z~v))
plot(graphpcor(y~x+z, v~z+x))
plot(graphpcor(y~x+z, v~x, z~v))

## the graph in Example 2.6 of the GMRF book
g <- graphpcor(x ~ y + v, z ~ y + v)

class(g)
g

par(mfrow=c(1,1))
plot(g)

summary(g) ## the graph: nodes and edges (nodes ordered as given)

ne <- dim(g)
ne

## sometimes we need it
G <- Laplacian(g)
G 

## alternatively
all.equal(G,
          Laplacian(graphpcor(x~y, v~x, y~z, z~v)))
all.equal(G,
          Laplacian(graphpcor(x~y, x~v, z~y, v~z)))

plot(graphpcor(G)) ## from a matrix

## base model (theta for lower triangle Cholesky)
theta0l <- rep(-0.5, ne[2])

## vcov() method for graphpcor computes the correlation
##  if only theta for lower of L is provided
C0 <- vcov(g, theta = theta0l)
C0

## the precision for a correlation matrix
Q0 <- prec(g, theta = theta0l)
Q0

all.equal(C0, as.matrix(solve(Q0)))

## the Hessian matrix around a base model
I0 <- basepcor(theta0l, p = ne[1], itheta = g)
I0

## a base model can also be a matrix
## however it shall give a precision with
## same sparse pattern as the graph
all.equal(I0, basepcor(C0, p = ne[1], itheta = g))

## the 'iid' case would be
vcov(g, theta = rep(0, ne[2]))
vcov(g, theta = rep(0, sum(ne)))

## marginal variance specified throught standard errors
sigmas <- c(0.3, 0.7, 1.2, 0.5)
## the covariance
vcov(g, theta = c(log(sigmas), rep(0, ne[2]))) ## IID
vcov(g, theta = c(log(sigmas), theta0l))

vcov(g, theta = rep(-3, ne[2])) ## no edge 2~3 but high correlation!!!

}
