% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_graphpcor.R
\name{cgeneric_graphpcor}
\alias{cgeneric_graphpcor}
\title{Build an \code{cgeneric} for a graph, see \code{\link[=graphpcor]{graphpcor()}}}
\usage{
cgeneric_graphpcor(
  model,
  lambda,
  base,
  sigma.prior.reference,
  sigma.prior.probability,
  params.id,
  cor.params.fixed,
  ...
)
}
\arguments{
\item{model}{a \code{graphpcor} (see \code{\link[=graphpcor]{graphpcor()}}) or
a square matrix (to be used as a graph)
to define the precision structure of the model.}

\item{lambda}{the parameter for the exponential prior on
the radius of the sphere, see details.}

\item{base}{numeric vector with length \code{m}, \code{m} is the
number of edges in the graph, or matrix with the reference
correlation model against what the KLD will be evaluated.
If it is a vector, a correlation matrix is defined
considering the graph model and this vector as
the parameters in the lower triangle matrix L.
If it is a matrix, it will be checked if the graph model
can generates this.}

\item{sigma.prior.reference}{numeric vector with length \code{n},
\code{n} is the number of nodes (variables) in the graph, as the
reference standard deviation to define the PC prior for each
marginal variance parameters. If missing, the model will be
assumed for a correlation. If a length \code{n} vector is given
and \code{sigma.prior.probability} is missing, it will be used as
known square root of the variances.
NOTE: \code{params.id} will be applied here as
\code{sigma.prior.reference[params.id[1:n]]}.}

\item{sigma.prior.probability}{numeric vector with length \code{n}
to set the probability statement of the PC prior for each
marginal variance parameters. The probability statement is
P(sigma < \code{sigma.prior.reference}) = p. If missing, all the
marginal variances are considered as known, as described in
\code{sigma.prior.reference}.
If a vector is given and a probability is NA, 0 or 1, the
corresponding \code{sigma.prior.reference} will be used as fixed.
NOTE: \code{params.id} will be applied here as
\code{sigma.prior.probability[params.id[1:n]]}.}

\item{params.id}{integer ordered vector with length equals
to \code{n+m} to specify common parameter values. If missing it
is assumed \code{1:(n+m)} and all parameters are assumed distinct.
The first \code{n} indexes the square root of the marginal
variances and the remaining indexes the edges parameters.
Example: By setting \code{params.id = c(1,1,2,3, 4,5,5,6)},
the first two standard deviations are common and the
second and third edges parameters are common as well,
giving 6 unknown parameters in the model.}

\item{cor.params.fixed}{numeric vector of length \code{m}
providing the value(s) at which the lower parameter(s)
of the L matrix to be fixed and not estimated.
NA indicates not fixed and all are set to be estimated by default.
Example: with \code{cor.params.fixed = c(NA, -1, NA, 1)} the first
and the third of these parameters will be estimated while
the second is fixed and equal to -1 and the forth is fixed
and equal to 1. NOTE: \code{params.id} will be applied here as
\code{cor.params.fixed[params.id[(n+1:m)]-n+1]}, thus the provided
examples give \verb{NA -1 -1 NA} and so the second and third low L
parameters are fixed to \code{-1}.}

\item{...}{additional arguments that will be passed on to
\code{\link[INLAtools:cgeneric-class]{INLAtools::cgenericBuilder()}}.}
}
\value{
\code{cgeneric} object.
}
\description{
From either a \code{graph} (see \code{\link[INLAtools:INLAtools-methods]{INLAtools::graph()}}) or
a square matrix (used as a graph),
creates an \code{cgeneric} (see \code{\link[INLAtools:cgeneric-class]{INLAtools::cgeneric()}})
to implement the Penalized Complexity prior using the
Kullback-Leibler divergence - KLD from a base graphpcor.
}
\seealso{
\code{\link[=graphpcor]{graphpcor()}}
}
