% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_helpers.R
\name{logdVK_HR}
\alias{logdVK_HR}
\title{Compute censored exponent measure}
\usage{
logdVK_HR(x, K, Gamma)
}
\arguments{
\item{x}{Numeric vector with \code{d} positive elements
where the censored exponent measure is to be evaluated.}

\item{K}{Integer vector, subset of 1, ..., \code{d}, the index set that is not censored.
Or logical vector of length \code{d}, indicating entries that are not censored.}

\item{Gamma}{d x d variogram matrix or numeric vector with d(d-1)/2 elements,
containing the upper triangular part of a variogram matrix.}
}
\value{
Numeric. The censored exponent measure of the HR distribution.
If no entries are censored, the result of \verb{logdV_HR(x, par} is returned.
}
\description{
Computes the (censored) exponent measure density of HR distribution.
}
\keyword{internal}
