% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.glmnet.R, R/plot.mrelnet.R,
%   R/plot.multnet.R, R/plot.relaxed.R
\name{plot.glmnet}
\alias{plot.glmnet}
\alias{plot.multnet}
\alias{plot.mrelnet}
\alias{plot.relaxed}
\title{plot coefficients from a "glmnet" object}
\usage{
\method{plot}{glmnet}(x, xvar = c("lambda", "norm", "dev"), label = FALSE, ...)

\method{plot}{mrelnet}(
  x,
  xvar = c("lambda", "norm", "dev"),
  label = FALSE,
  type.coef = c("coef", "2norm"),
  ...
)

\method{plot}{multnet}(
  x,
  xvar = c("lambda", "norm", "dev"),
  label = FALSE,
  type.coef = c("coef", "2norm"),
  ...
)

\method{plot}{relaxed}(x, xvar = c("lambda", "dev"), label = FALSE, gamma = 1, ...)
}
\arguments{
\item{x}{fitted \code{"glmnet"} model}

\item{xvar}{What is on the X-axis. \code{"lambda"} plots against the log-lambda sequence,
\code{"norm"} against the L1-norm of the coefficients, and
\code{"dev"} against the percent deviance explained. Warning: "norm" is the L1 norm of the coefficients on the glmnet object. There are many reasons why this might not be appropriate, such as automatic standardization, penalty factors, and values of \code{alpha} less than 1, which can lead to unusual looking plots.}

\item{label}{If \code{TRUE}, label the curves with variable sequence
numbers.}

\item{\dots}{Other graphical parameters to plot}

\item{type.coef}{If \code{type.coef="2norm"} then a single curve per
variable, else if \code{type.coef="coef"}, a coefficient plot per response}

\item{gamma}{Value of the mixing parameter for a "relaxed" fit}
}
\description{
Produces a coefficient profile plot of the coefficient paths for a fitted
\code{"glmnet"} object.
}
\details{
A coefficient profile plot is produced. If \code{x} is a multinomial model,
a coefficient plot is produced for each class.
}
\examples{
x=matrix(rnorm(100*20),100,20)
y=rnorm(100)
g2=sample(1:2,100,replace=TRUE)
g4=sample(1:4,100,replace=TRUE)
fit1=glmnet(x,y)
plot(fit1)
plot(fit1,xvar="lambda",label=TRUE)
fit3=glmnet(x,g4,family="multinomial")
plot(fit3,pch=19)
}
\references{
Friedman, J., Hastie, T. and Tibshirani, R. (2008)
\emph{Regularization Paths for Generalized Linear Models via Coordinate
Descent}
}
\seealso{
\code{glmnet}, and \code{print}, \code{predict} and \code{coef}
methods.
}
\author{
Jerome Friedman, Trevor Hastie and Rob Tibshirani\cr Maintainer:
Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{models}
\keyword{regression}
