% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tree.r
\docType{methods}
\name{[,git_tree,integer,missing-method}
\alias{[,git_tree,character,missing-method}
\alias{[,git_tree,integer,missing-method}
\alias{[,git_tree,logical,missing-method}
\alias{[,git_tree,numeric,missing-method}
\title{Extract object from tree}
\usage{
\S4method{[}{git_tree,integer,missing}(x, i)

\S4method{[}{git_tree,numeric,missing}(x, i)

\S4method{[}{git_tree,logical,missing}(x, i)

\S4method{[}{git_tree,character,missing}(x, i)
}
\arguments{
\item{x}{The tree \code{object}}

\item{i}{The index (integer or logical) of the tree object to
extract. If negative values, all elements except those indicated
are selected. A character vector to match against the names of
objects to extract.}
}
\value{
Git object
}
\description{
Lookup a tree entry by its position in the tree
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
dir.create(file.path(path, "subfolder"))
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Create three files and commit
writeLines("First file",  file.path(path, "example-1.txt"))
writeLines("Second file", file.path(path, "subfolder/example-2.txt"))
writeLines("Third file",  file.path(path, "example-3.txt"))
add(repo, c("example-1.txt", "subfolder/example-2.txt", "example-3.txt"))
new_commit <- commit(repo, "Commit message")

## Pick a tree in the repository
tree_object <- tree(new_commit)

## Summarize tree
summary(tree_object)

## Select item by name
tree_object["example-1.txt"]

## Select first item in tree
tree_object[1]

## Select first three items in tree
tree_object[1:3]

## Select all blobs in tree
tree_object[sapply(as(tree_object, 'list'), is_blob)]
}
}
\keyword{methods}

