% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/repository.r
\docType{methods}
\name{head,git_repository-method}
\alias{head,git_repository-method}
\title{Get HEAD for a repository}
\usage{
\S4method{head}{git_repository}(x)
}
\arguments{
\item{x}{The repository \code{x} to check head}
}
\value{
NULL if unborn branch or not found. S4 class git_branch if
not a detached head. S4 class git_commit if detached head
}
\description{
Get HEAD for a repository
}
\examples{
\dontrun{
## Create and initialize a repository in a temporary directory
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add and commit
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "Commit message")

## Get HEAD of repository
head(repo)
}
}
\keyword{methods}

