% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{status}
\alias{status}
\title{Status}
\usage{
status(
  repo = ".",
  staged = TRUE,
  unstaged = TRUE,
  untracked = TRUE,
  ignored = FALSE,
  all_untracked = FALSE
)
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}

\item{staged}{Include staged files. Default TRUE.}

\item{unstaged}{Include unstaged files. Default TRUE.}

\item{untracked}{Include untracked files and directories. Default
TRUE.}

\item{ignored}{Include ignored files. Default FALSE.}

\item{all_untracked}{Shows individual files in untracked
directories if \code{untracked} is \code{TRUE}.}
}
\value{
\code{git_status} with repository status
}
\description{
Display state of the repository working directory and the staging
area.
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Config user
config(repo, user.name = "Alice", user.email = "alice@example.org")

## Create a file
writeLines("Hello world!", file.path(path, "test.txt"))

## Check status; untracked file
status(repo)

## Add file
add(repo, "test.txt")

## Check status; staged file
status(repo)

## Commit
commit(repo, "First commit message")

## Check status; clean
status(repo)

## Change the file
writeLines(c("Hello again!", "Here is a second line", "And a third"),
           file.path(path, "test.txt"))

## Check status; unstaged file
status(repo)

## Add file and commit
add(repo, "test.txt")
commit(repo, "Second commit message")

## Check status; clean
status(repo)
}
}
