% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commit.r
\docType{methods}
\name{parents}
\alias{parents}
\alias{parents,git_commit-method}
\title{Parents}
\usage{
parents(object)

\S4method{parents}{git_commit}(object)
}
\arguments{
\item{object}{a S4 class git_commit \code{object}.}
}
\value{
list of S4 git_commit objects
}
\description{
Get parents of a commit.
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("First line.",
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit_1 <- commit(repo, "First commit message")

## commit_1 has no parents
parents(commit_1)

## Update 'example.txt' and commit
writeLines(c("First line.", "Second line."),
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit_2 <- commit(repo, "Second commit message")

## commit_2 has commit_1 as parent
parents(commit_2)
}
}
\keyword{methods}
