% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reference.r
\docType{methods}
\name{references}
\alias{references}
\alias{references,git_repository-method}
\title{Get all references that can be found in a repository.}
\usage{
references(repo)

\S4method{references}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository \code{object}.}
}
\value{
Character vector with references
}
\description{
Get all references that can be found in a repository.
}
\examples{
\dontrun{
## Initialize two temporary repositories
path_bare <- tempfile(pattern="git2r-")
path_repo <- tempfile(pattern="git2r-")
dir.create(path_bare)
dir.create(path_repo)
repo_bare <- init(path_bare, bare = TRUE)
repo <- clone(path_bare, path_repo)

## Config user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path_repo, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Push commits from repository to bare repository
## Adds an upstream tracking branch to branch 'master'
push(repo, "origin", "refs/heads/master")

## Add tag to HEAD
tag(repo, "v1.0", "First version")

## Create a note
note_create(commits(repo)[[1]], "My note")

## List all references in repository
references(repo)
}
}
\keyword{methods}

