% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reflog.r
\docType{methods}
\name{show,git_reflog_entry-method}
\alias{show,git_reflog_entry-method}
\alias{show,git_reflog_entry-methods}
\title{Brief summary of a reflog entry}
\usage{
\S4method{show}{git_reflog_entry}(object)
}
\arguments{
\item{object}{The reflog entry \code{object}}
}
\value{
None (invisible 'NULL').
}
\description{
Brief summary of a reflog entry
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## View repository HEAD reflog
reflog(repo)
}
}
\keyword{methods}

