% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship2_alignped3.R
\name{kinship2_alignped3}
\alias{kinship2_alignped3}
\title{Merge two aligned pedigree structures}
\usage{
kinship2_alignped3(x1, x2, packed, space = 1)
}
\arguments{
\item{x1}{First aligned pedigree structure (list)}

\item{x2}{Second aligned pedigree structure (list)}

\item{packed}{Logical, if TRUE uses compact packing; if FALSE adds spacing}

\item{space}{Numeric, horizontal spacing between structures when packed=FALSE (default 1)}
}
\value{
A list containing the merged pedigree structure:
  \item{n}{Vector of counts per level}
  \item{nid}{Matrix of subject IDs at each level and position}
  \item{pos}{Matrix of horizontal positions}
  \item{fam}{Matrix of family indices}
}
\description{
This is an internal helper function for pedigree alignment. It takes two
previously aligned pedigree structures (x1 and x2) and merges them side-by-side,
handling overlapping subjects and adjusting positions appropriately.
}
\keyword{internal}
