% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggBar.R
\name{ggBar}
\alias{ggBar}
\title{Draw an interactive barplot}
\usage{
ggBar(data, mapping, stat = "count", position = "stack", palette = NULL,
  horizontal = FALSE, yangle = 0, xangle = 0, maxylev = 6,
  addlabel = FALSE, labelsize = 5, polar = FALSE, reverse = FALSE,
  use.label = TRUE, use.labels = TRUE, interactive = FALSE, ...)
}
\arguments{
\item{data}{A data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{stat}{The statistical transformation to use on the data for this layer, as a string
c("count","identity")}

\item{position}{Position adjustment. One of the c("fill","stack","dodge")}

\item{palette}{A character string indicating the color palette}

\item{horizontal}{A logical value. If TRUE,a horizontal bar plot will be returned}

\item{yangle}{An integer. The value will be used adjust the angle of axis.text.y}

\item{xangle}{An integer. The value will be used adjust the angle of axis.text.x}

\item{maxylev}{integer indicating threshold of unique value to be treated as a categorical variable}

\item{addlabel}{A logical value. If TRUE, label will be added to the plot}

\item{labelsize}{label size}

\item{polar}{A logical value. If TRUE, coord_polar() function will be added}

\item{reverse}{If true, reverse palette colors}

\item{use.label}{Logical. Whether or not use column label in case of labelled data}

\item{use.labels}{Logical. Whether or not use value labels in case of labelled data}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}

\item{...}{other arguments passed on to geom_bar_interactive.}
}
\value{
An interactive barplot
}
\description{
Draw an interactive barplot
}
\examples{
require(moonBook)
require(ggplot2)
require(ggiraph)
require(plyr)
ggBar(acs,aes(x=Dx,fill=smoking),interactive=TRUE,width=1,colour="white",size=0.2,polar=TRUE)
ggBar(acs,aes(x=Dx,fill=smoking),position="fill",addlabel=TRUE,horizontal=TRUE,width=0.5)
ggBar(acs,aes(x=Dx,fill=smoking),position="dodge",interactive=TRUE,addlabel=TRUE)
ggBar(acs,aes(x=Dx,fill=smoking),position="fill",addlabel=TRUE)
ggBar(rose,aes(x=Month,fill=group,y=value),stat="identity",polar=TRUE,palette="Reds",width=1,
      color="black",size=0.1,reverse=TRUE,interactive=TRUE)
}
