% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggHSD.R
\name{ggHSD}
\alias{ggHSD}
\title{Draw Tukey Honest Significant Differences plot}
\usage{
ggHSD(tukey, no = 1, digits = 2, interactive = FALSE)
}
\arguments{
\item{tukey}{A object of class "TukeyHSD", the result of TukeyHSD()}

\item{no}{An integer specify the order of list}

\item{digits}{integer indicating the number of decimal places}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}
}
\value{
A (interactive) ggplot
}
\description{
Draw Tukey Honest Significant Differences plot
}
\examples{
require(ggplot2)
fm1 <- aov(breaks ~ wool + tension, data = warpbreaks)
result=TukeyHSD(fm1, "tension", ordered = TRUE)
str(result)
ggHSD(result)
}

