% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_boxplot_interactive.R
\name{geom_boxplot_interactive}
\alias{geom_boxplot_interactive}
\title{Create interactive boxplot}
\usage{
geom_boxplot_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
The geometry is based on \code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}.
See the documentation for that function for more details.
}
\details{
You can supply \verb{interactive parameters} for the outlier points by prefixing them
with \code{outlier.} prefix. For example: aes(outlier.tooltip = 'bla', outlier.data_id = 'blabla').

IMPORTANT: when supplying outlier interactive parameters,
the correct \code{group} aesthetic \emph{must} be also supplied. Otherwise the default group calculation
will be incorrect, which will result in an incorrect plot.
}
\section{Details for interactive geom functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[ggplot2:aes]{ggplot2::aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive boxplot -------
library(ggplot2)
library(ggiraph)

p <- ggplot(mpg, aes(x = class, y = hwy, tooltip = class)) +
  geom_boxplot_interactive()

x <- girafe(ggobj = p)
if (interactive()) print(x)

p <- ggplot(mpg) +
  geom_boxplot_interactive(
    aes(
      x = drv, y = hwy,
      fill = class,
      data_id = class,
      tooltip = after_stat({
        paste0(
          "class: ", .data$fill,
          "\nQ1: ", prettyNum(.data$lower),
          "\nQ3: ", prettyNum(.data$upper),
          "\nmedian: ", prettyNum(.data$middle)
        )
      })
    ),
    outlier.colour = "red"
  ) +
  guides(fill = "none") +
  theme_minimal()

x <- girafe(ggobj = p)
if (interactive()) print(x)


p <- ggplot(mpg) +
  geom_boxplot_interactive(
    aes(
      x = drv, y = hwy,
      fill = class, group = paste(drv, class),
      data_id = class,
      tooltip = after_stat({
        paste0(
          "class: ", .data$fill,
          "\nQ1: ", prettyNum(.data$lower),
          "\nQ3: ", prettyNum(.data$upper),
          "\nmedian: ", prettyNum(.data$middle)
        )
      }),
      outlier.tooltip = paste(
        "I am an outlier!\nhwy:", hwy, "\ndrv:", drv, "\nclass:", class
      )
    ),
    outlier.colour = "red"
  ) +
  guides(fill = "none") +
  theme_minimal()

x <- girafe(ggobj = p)
if (interactive()) print(x)
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
