% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emm.R
\name{emm}
\alias{emm}
\title{Get marginal effects for model response}
\usage{
emm(model, ci.lvl = 0.95, type = c("fe", "re"), typical = "mean",
  ...)
}
\arguments{
\item{model}{A fitted model object, or a list of model objects. Any model
that supports common methods like \code{predict()}, \code{family()}
or \code{model.frame()} should work. For \code{ggeffect()}, any model
that is supported by the \CRANpkg{effects}-package should work.}

\item{ci.lvl}{Numeric, the level of the confidence intervals. For \code{ggpredict()},
use \code{ci.lvl = NA}, if confidence intervals should not be calculated
(for instance, due to computation time).}

\item{type}{Character, only applies for mixed effects models and/or models
with zero-inflation.
\describe{
  \item{\code{"fe"}}{
  Predicted values are conditioned on the fixed effects or conditional
  model only. For instance, for models fitted with \code{zeroinfl} from
  \pkg{pscl}, this would return the predicted mean from the count component
  (without zero-inflation). For models of class \code{glmmTMB}, this type
  calls \code{predict(..., type = "link")}.
  }
  \item{\code{"re"}}{
  Predicted values are conditioned on the random effects. This only applies
  to mixed models, and \code{type = "re"} does not condition on the
  zero-inflation component of the model. Prediction intervals also consider
  the uncertainty in the variance parameters. For models of class \code{glmmTMB},
  this type calls \code{predict(..., type = "link")}. \strong{Note:} For
  models of class \code{glmmTMB}, the random effect variances only affect
  the confidence intervals of predictions, not the predicted values
  themselves (because this is currently not implemented in \pkg{glmmTMB}).
  }
  \item{\code{"fe.zi"}}{
  Predicted values are conditioned on the fixed effects and the zero-inflation
  component. For instance, for models fitted with \code{zeroinfl}
  from \pkg{pscl}, this would return the predicted response and for \code{glmmTMB},
  this would return the expected value \code{mu*(1-p)} \emph{without}
  conditioning on random effects. For models of class \code{glmmTMB}, this type
  calls \code{predict(..., type = "response")}.
  }
  \item{\code{"re.zi"}}{
  Predicted values are conditioned on the random effects and the
  zero-inflation component. For models fitted with \code{glmmTMB}, this
  would return the expected value \code{mu*(1-p)}, conditioned on random
  effects. Prediction intervals also consider the uncertainty in the
  variance parameters. For models of class \code{glmmTMB}, this type
  calls \code{simulate()}, because conditioning on random effects is
  not yet implemented in \code{predict.glmmTMB()}.
  }
  \item{\code{"surv"} and \code{"cumhaz"}}{
  Applies only to \code{coxph}-objects from the \pkg{survial}-package and
  calculates the survival probability or the cumulative hazard of an event.
  }
  \item{\code{"debug"}}{
  Only used internally.
  }
}}

\item{typical}{Character vector, naming the function to be applied to the
covariates over which the effect is "averaged". The default is "mean".
See \code{\link[sjstats]{typical_value}} for options.}

\item{...}{For \code{ggpredict()}, further arguments passed down to
\code{predict()}, and for \code{ggeffect()}, further arguments passed
down to \code{\link[effects]{Effect}}. If \code{model} is of class
\code{glmmTMB}, \code{...} may also be used to set the number of
simulation for bootstrapped confidence intervals, e.g. \code{nsim = 500}.}
}
\value{
A data frame with the marginal effect of the response (\code{predicted})
        and the confidence intervals \code{conf.low} and \code{conf.high}.
        For \code{polr}-objects, the marginal effect for each level of the
        response variable is returned.
}
\description{
\code{emm()} is a convenient shortcut to compute the estimated
             marginal mean, resp. the marginal effect of the model's response
             variable, with all independent variables held constant (at
             their \code{\link[sjstats]{typical_value}}).
}
\details{
For linear models, the predicted value is the estimated marginal
         mean. Else, the predicted value is on the scale of the inverse of
         link function.
}
\examples{
data(efc)
fit <- lm(barthtot ~ c12hour + neg_c_7 + c161sex + c172code, data = efc)
emm(fit)

# Example from ?MASS::polr
library(MASS)
options(contrasts = c("contr.treatment", "contr.poly"))
house.plr <- polr(Sat ~ Infl + Type + Cont, weights = Freq, data = housing)
emm(house.plr)

}
