% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpoly.R
\name{ggpoly}
\alias{ggpoly}
\title{Get marginal effects for polynomial terms}
\usage{
ggpoly(model, poly.term, ci.lvl = 0.95, ...)
}
\arguments{
\item{model}{A fitted model object, or a list of model objects. Any model
that is supported by the \CRANpkg{effects}-package should work.}

\item{poly.term}{Name of the polynomial term in \code{model}, as string.}

\item{ci.lvl}{Numeric, the level of the confidence intervals. For \code{ggpredict()},
use \code{ci.lvl = NA}, if confidence intervals should not be calculated
(for instance, due to computation time).}

\item{...}{Further arguments passed down to \code{\link[effects]{effect}}.}
}
\value{
A tibble (with \code{ggeffects} class attribute) with consistent data columns:
        \describe{
          \item{\code{x}}{the values of the first term in \code{terms}, used as x-position in plots.}
          \item{\code{predicted}}{the predicted values, used as y-position in plots.}
          \item{\code{conf.low}}{the lower bound of the confidence interval for the predicted values.}
          \item{\code{conf.high}}{the upper bound of the confidence interval for the predicted values.}
          \item{\code{group}}{the grouping level from the second term in \code{terms}, used as grouping-aesthetics in plots.}
        }
}
\description{
\code{ggpoly()} computes marginal effects for polynomial terms.
             The result is returned as tidy data frame.
}
\examples{
data(efc)
fit <- lm(
  tot_sc_e ~ c12hour + e42dep + e17age + I(e17age^2) + I(e17age^3),
  data = efc
)
dat <- ggpoly(fit, "e17age")

# this would give the same result
ggpredict(fit, "e17age")

library(ggplot2)
ggplot(dat, aes(x, predicted)) +
  stat_smooth(se = FALSE) +
  geom_ribbon(aes(ymin = conf.low, ymax = conf.high), alpha = .15) +
  labs(x = get_x_title(dat), y = get_y_title(dat))

\dontrun{
# or:
plot(dat)}

}
