% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-operation-affine-transform.R,
%   R/operation-affine-transform.R
\docType{class}
\name{affine_transform}
\alias{affine_transform}
\alias{affine_transform-class}
\title{Translate, scale, and rotate ggplot2 layers (Layer operation)}
\usage{
affine_transform(object, x = 0, y = 0, width = 1, height = 1, angle = 0)
}
\arguments{
\item{object}{One of:
\itemize{
\item A \link{layer-like} object: applies this operation to the layer.
\item A missing argument: creates an \link{operation}
\item A \code{numeric()} or \code{unit()} giving the x-axis translation,
which takes the place of the \code{x} argument.
}}

\item{x}{A \code{numeric()} or \code{unit()} giving the x translation to apply.}

\item{y}{A \code{numeric()} or \code{unit()} giving the y translation to apply.}

\item{width}{A \code{numeric()} or \code{unit()} giving the width.}

\item{height}{A \code{numeric()} or \code{unit()} giving the height.}

\item{angle}{A \code{numeric()} giving the angle to rotate, in degrees.}
}
\value{
A \link{layer-like} object (if \code{object} is \link{layer-like}) or an \link{operation} (if not).
}
\description{
Transform objects within a single layer (geom) or across multiple layers (geoms)
using affine transformations, like translation, scale, and rotation. Uses
the built-in compositing support in graphical devices added in R 4.2.
}
\details{
Applies an affine transformation (translation, scaling, rotation) to a layer.

\strong{Note:} due to limitations in the implementation of scaling and rotation,
currently these operations can only be performed relative to the center of
the plot. In future versions, the translation and rotation origin may be
configurable.
}
\section{Supported devices}{

Transformation is not currently supported by all graphics devices. As of this writing,
at least \code{png(type = "cairo")}, \code{svg()}, and \code{cairo_pdf()} are known to support
blending.

\code{affine_transform()} attempts to auto-detect support for affine transformation using \code{dev.capabilities()}.
You may receive a warning when using \code{affine_transform()} if it appears transformation is not
supported by the current graphics device. This warning \strong{either} means (1)
your graphics device does not support transformation (in which case you should
switch to one that does) or (2) your graphics device
supports transformation but incorrectly reports that it does not. Unfortunately,
not all graphics devices that support transformation appear to correctly \emph{report}
that they support transformation, so even if auto-detection fails, \code{blend()} will
still attempt to apply the transformation, just in case.

If the warning is issued and the output is still correctly transformed, this is
likely a bug in the graphics device. You can report the bug to the authors of
the graphics device if you wish; in the mean time, you can use
\code{options(ggblend.check_affine_transform = FALSE)} to disable the check.
}

\examples{
\dontshow{old_options = options(ggblend.check_affine_transform = FALSE)}
library(ggplot2)

# a simple dataset:
set.seed(1234)
data.frame(x = rnorm(100), y = rnorm(100)) |>
  ggplot(aes(x, y)) +
  geom_point() +
  xlim(-5, 5)

# we could scale and translate copies of the point cloud
# (though I'm not sure why...)
data.frame(x = rnorm(100), y = rnorm(100)) |>
  ggplot(aes(x, y)) +
  geom_point() * (
    affine_transform(x = -unit(100, "pt"), width = 0.5) |> adjust(color = "red") +
    affine_transform(width = 0.5) +
    affine_transform(x = unit(100, "pt"), width = 0.5) |> adjust(color = "blue")
  ) +
  xlim(-5, 5)
\dontshow{options(old_options)}
}
\references{
Murrell, Paul (2021):
\href{https://www.stat.auckland.ac.nz/~paul/Reports/GraphicsEngine/groups/groups.html}{Groups, Compositing Operators, and Affine Transformations in R Graphics}.
The University of Auckland. Report.
\doi{10.17608/k6.auckland.17009120.v1}.
}
\seealso{
\link{operation} for a description of layer operations.

Other layer operations: 
\code{\link{adjust}},
\code{\link{blend}},
\code{\link{copy}},
\code{\link{nop}},
\code{\link{partition}()}
}
\concept{layer operations}
