% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_ash.r
\name{stat_ash}
\alias{stat_ash}
\title{Compute and display a univariate averaged shifted histogram (polynomial kernel)}
\usage{
stat_ash(mapping = NULL, data = NULL, geom = "area", position = "stack",
  ab = NULL, nbin = 50, m = 5, kopt = c(2, 2), na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{geom}{Use to override the default Geom}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{ab}{half-open interval for bins \emph{[a,b)}. If no value is specified,
the range of x is stretched by \code{5\%} at each end and used the
interval.}

\item{nbin}{number of bins desired. Default \code{50}.}

\item{m}{integer smoothing parameter; Default \code{5}.}

\item{kopt}{vector of length 2 specifying the kernel, which is proportional
to \emph{( 1 - abs(i/m)^kopt(1) )i^kopt(2)}; (2,2)=biweight (default);
 (0,0)=uniform; (1,0)=triangle; (2,1)=Epanechnikov; (2,3)=triweight.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
See \code{\link[ash]{bin1}} & \code{\link[ash]{ash1}} for more information.
}
\details{
\if{html}{
A sample of the output from \code{stat_ash()}:

\figure{statash01.png}{options: width="100\%" alt="Figure: statash01.png"}
}

\if{latex}{
A sample of the output from \code{stat_ash()}:

\figure{statash01.png}{options: width=10cm}
}
}
\section{Aesthetics}{

\code{geom_ash} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \code{alpha}
  \item \code{color}
  \item \code{fill}
  \item \code{linetype}
  \item \code{size}
}
}

\section{Computed variables}{

\describe{
  \item{\code{density}}{ash density estimate}
}
}

\examples{
# compare
library(gridExtra)
set.seed(1492)
dat <- data.frame(x=rnorm(100))
grid.arrange(ggplot(dat, aes(x)) + stat_ash(),
             ggplot(dat, aes(x)) + stat_bkde(),
             ggplot(dat, aes(x)) + stat_density(),
             nrow=3)

cols <- RColorBrewer::brewer.pal(3, "Dark2")
ggplot(dat, aes(x)) +
  stat_ash(alpha=1/2, fill=cols[3]) +
  stat_bkde(alpha=1/2, fill=cols[2]) +
  stat_density(alpha=1/2, fill=cols[1]) +
  geom_rug() +
  labs(x=NULL, y="density/estimate") +
  scale_x_continuous(expand=c(0,0)) +
  theme_bw() +
  theme(panel.grid=element_blank()) +
  theme(panel.border=element_blank())
}
\references{
David Scott (1992), \emph{"Multivariate Density Estimation,"}
            John Wiley, (chapter 5 in particular).\cr
            \cr
            B. W. Silverman (1986), \emph{"Density Estimation for Statistics
            and Data Analysis,"} Chapman & Hall.
}
