% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.r
\name{byte_format}
\alias{byte_format}
\alias{Kb}
\alias{Mb}
\alias{Gb}
\alias{bytes}
\title{Bytes formatter: convert to byte measurement and display symbol.}
\usage{
byte_format(symbol = "auto", units = "binary")

Kb(x)

Mb(x)

Gb(x)

bytes(x, symbol = "auto", units = c("binary", "si"))
}
\arguments{
\item{symbol}{byte symbol to use. If "\code{auto}" the symbol used will be
determined by the maximum value of \code{x}. Valid symbols are
"\code{b}", "\code{K}", "\code{Mb}", "\code{Gb}", "\code{Tb}", "\code{Pb}",
"\code{Eb}", "\code{Zb}", and "\code{Yb}", along with their upper case
equivalents and "\code{iB}" equivalents.}

\item{units}{which unit base to use, "\code{binary}" (1024 base) or
"\code{si}" (1000 base) for ISI units.}

\item{x}{a numeric vector to format}
}
\value{
a function with three parameters, \code{x}, a numeric vector that
  returns a character vector, \code{symbol} the byte symbol (e.g. "\code{Kb}")
  desired and the measurement \code{units} (traditional \code{binary} or
  \code{si} for ISI metric units).
}
\description{
Bytes formatter: convert to byte measurement and display symbol.
}
\examples{
byte_format()(sample(3000000000, 10))
bytes(sample(3000000000, 10))
Kb(sample(3000000000, 10))
Mb(sample(3000000000, 10))
Gb(sample(3000000000, 10))
}
\references{
Units of Information (Wikipedia) :
  \url{http://en.wikipedia.org/wiki/Units_of_information}
}
