% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setOperations.R
\name{overlap}
\alias{overlap}
\alias{overlap,Venn-method}
\title{Intersection of many sets.}
\usage{
overlap(venn, slice = "all")

\S4method{overlap}{Venn}(venn, slice = "all")
}
\arguments{
\item{venn}{(Required) A \code{Venn} object.}

\item{slice}{(Optional) The names or the indices of sets of interest. Default
is "all", meaning the intersection will be calculated for all the sets.}
}
\value{
A vector showing the intersection of the sets.
}
\description{
\code{overlap} returns the same elements of the sets in a \code{Venn} object.
}
\examples{
venn = Venn(list(letters[1:10], letters[3:12], letters[6:15]))
overlap(venn)
overlap(venn, slice = c(1, 2))
}
\author{
tyakyol@gmail.com
}
