% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classVenn.R
\docType{class}
\name{Venn-class}
\alias{Venn-class}
\alias{Venn}
\alias{Venn,ANY-method}
\alias{show,Venn-method}
\title{\emph{\code{Venn}} is a S4 class to represent multiple sets.}
\usage{
Venn(sets, names = NULL)

\S4method{Venn}{ANY}(sets, names = NULL)

\S4method{show}{Venn}(object)
}
\arguments{
\item{sets}{(Required) A list containing vectors in the same class. If a
vector contains duplicates they will be discarded. If the list doesn't have
names the sets will be named as "Set_1", "Set_2", "Set_3" and so on.}

\item{names}{names of sets}

\item{object}{a Venn class object}
}
\value{
A \code{Venn} object.
}
\description{
Print user-friendly information of a Venn object
}
\section{Slots}{

\describe{
\item{\code{sets}}{A \code{list} object containing vectors in the same type.}

\item{\code{names}}{The names of the \code{sets} if it has names. If the \code{list}
doesn't have names, the sets will be named as "Set_1", "Set_2", "Set_3" and
so on.}
}}

\examples{
 venn = Venn(list(letters[1:10], letters[3:12], letters[6:15]))
 print(venn)
}
