% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3method.R
\name{summary.ICE}
\alias{summary.ICE}
\title{Summary method for ICE Estimator Objects}
\usage{
\method{summary}{ICE}(...)
}
\arguments{
\item{...}{the ICE estimator objects.}
}
\value{
a data frame containing the summary table for all specified ICE estimator objects.
}
\description{
This function returns a summary table for ICE estimator objects.
}
\examples{

data <- gfoRmulaICE::compData

fit_classical_pool <- ice(
data = data, 
time_points = 4, 
id = "id", 
time_name = "t0",
censor_name = "C", 
outcome_name = "Y",
compevent_name = "D",
comp_effect = 0,
outcome_model = Y ~ L1 + L2 + A1 + A2, 
censor_model = C ~ L1 + L2 + A1 + A2,
ref_idx = 0,
estimator = pool(hazard = FALSE),
int_descript = c("Static Intervention"),
intervention1.A1 = list(static(3)),
intervention1.A2 = list(static(1))
)

fit_hazard_pool <- ice(
data = data, 
time_points = 4, 
id = "id", 
time_name = "t0",
censor_name = "C", 
outcome_name = "Y",
compevent_name = "D",
comp_effect = 0,
outcome_model = Y ~ L1 + L2 + A1 + A2, 
censor_model = C ~ L1 + L2 + A1 + A2,
competing_model = D ~ L1 + L2 + A1 + A2,
ref_idx = 0,
estimator = pool(hazard = TRUE),
int_descript = c("Static Intervention"),
intervention1.A1 = list(static(3)),
intervention1.A2 = list(static(1))
)

summary(fit_classical_pool, fit_hazard_pool)
}
