% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothingZone.R
\name{zone.extended}
\alias{zone.extended}
\title{zone.extended}
\usage{
zone.extended(z, boundary)
}
\arguments{
\item{z}{a zone of the map}

\item{boundary}{union of all zones of the corrected map (result of correctBoundaryMap())}
}
\description{
zone.extended
}
\details{
for a zone that has commun border with the map, it will be extended at the side of commun border. We search the commun border which is
a spatiaLines. This spatialLines is composed of several Lines containing only 2 points. For each Lines, we project the 2 points to the
convexHull of the "relaxation" of the map's boundary. We have then 4 points (2 come from a Line, 2 come from the projection). with 4 points,
we will have a SpatialPolygone which is the extension part of the Line.
}
\examples{
\donttest{
seed=1
map = genMap(DataObj=NULL,seed=seed,disp=FALSE,krig=2,typeMod="Exp",nPointsK=500)
criti = correctionTree(qProb = c(0.5), map = map)
Z = criti$zk[[1]][[1]]$zonePolygone
lab = criti$zk[[1]][[1]]$lab
# zones' correction
res = correctBoundaryMap(Zi = Z, map = map)
Z = res$Z
# map boundary after correction
boundary = Z[[1]]
for(i in 2:length(Z)){
  boundary = rgeos::gUnion(boundary, Z[[i]])
}
# plot map
plotM(map = map, Z = Z, lab = lab, byLab = FALSE)
# extend zone
z = geozoning:::zone.extended(z = Z[[1]], boundary = boundary)
sp::plot(z)
sp::plot(Z[[1]],add=TRUE)
}
}
