% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotM.R
\name{plotM}
\alias{plotM}
\title{plotM}
\usage{
plotM(map, Z = NULL, lab = NULL, byLab = TRUE, quantile = NULL,
  crit = NULL, cost = NULL, bestCrit = NULL, bestCost = NULL,
  newCost = NULL, line = 0, cex = 2)
}
\arguments{
\item{map}{object returned by function genMap}

\item{Z}{list of zones, each zone is a SpatialPolygons.}

\item{lab}{label of each zones.}

\item{byLab}{boolean, if TRUE display the label of each zone, else display the zone number.}

\item{quantile}{probability vector used to generate "Z". This will be displayed in the title of the plot.}

\item{crit}{criterion value corresponding to "Z. This will be displayed in the title of the plot.}

\item{cost}{cost value corresponding to "Z". This will be displayed in the title of the plot.}

\item{bestCrit}{best criterion value. This will be displayed in the title of the plot.}

\item{bestCost}{best cost value. This will be displayed in the title of the plot.}

\item{newCost}{new cost value. This will be displayed in the title of the plot.}

\item{line}{position of the title. if negative, the title goes down, otherwise, goes up.}

\item{cex}{text size}
}
\value{
an empty value
}
\description{
plotM
}
\details{
plot the map in color with zones and details.
}
\examples{
map=geozoning::mapTest
ZK=initialZoning(qProb=c(0.55,0.85),map)
Z=ZK$resZ$zonePolygone # list of zones
lab = ZK$resZ$lab # label of zones
plotM(map = map,Z = Z,lab = lab, byLab = FALSE)

}
