% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{SigmaL2}
\alias{SigmaL2}
\title{SigmaL2}
\usage{
SigmaL2(zlab, listZonePoint, tabVal, surfVoronoi)
}
\arguments{
\item{zlab}{list with zone numbers for each zone label}

\item{listZonePoint}{list of indices of data points within zones, result of call to \code{\link{calNei}}}

\item{tabVal}{SpatialPointsDataFrame containing data values}

\item{surfVoronoi}{Surfaces of the Voronoi polygons corresponding to data pts}
}
\value{
a list with components
\describe{
\item{cL}{weighted (with Voronoi surfaces) average of per label variances}
\item{SigmaL2}{vector of per label variances}
\item{SL}{vector of per label Voronoi surfaces}
\item{mL}{vector of weighted (with Voronoi surfaces) per label average values}
\item{voroLab}{vector of per label data}
}
}
\description{
SigmaL2
}
\details{
compute overall mean and variance of all zones for each label plus sum of them for all labels
}
\examples{
\donttest{
data(mapTest)
# run zoning with 2 quantiles corresponding to probability values 0.4 and 0.7
# save initial zoning and last level zonings
criti=correctionTree(c(0.4,0.7),mapTest,SAVE=TRUE)
K=criti$zk[[2]][[1]]
uni=unique(K$lab)
zlab=sapply(uni,function(x){(1:length(K$lab))[K$lab==x]})
sig=SigmaL2(zlab,K$listZonePoint,mapTest$krigData,mapTest$krigSurfVoronoi)
}
}
