% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calDistance.R
\name{distanceNormalisationSqrt}
\alias{distanceNormalisationSqrt}
\title{distanceNormalisationSqrt}
\usage{
distanceNormalisationSqrt(matDistance)
}
\arguments{
\item{matDistance}{distance matrix as returned by a call to calDistance}
}
\value{
a normalized distance matrix
}
\description{
distanceNormalisationSqrt
}
\details{
normalize all MIJ terms of the distance matrix by dividing it by square root of diagonal terms MII*MJJ
}
\examples{
# load test map with simulated data
data(mapTest)
# load zoning results from test file
data(resZTest)
K=resZTest
resD = calDistance(typedist=1,mapTest$krigData,K$listZonePoint,K$zoneN,
       mapTest$krigSurfVoronoi,K$meanZone,pErr=0.9)
geozoning:::distanceNormalisationSqrt(resD$matDistanceCorr)
}
\keyword{internal}
