% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSShapefileDataStore.R
\docType{class}
\name{GSShapefileDataStore}
\alias{GSShapefileDataStore}
\title{Geoserver REST API ShapeFileDataStore}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling a GeoServer Shapefile dataStore
}
\description{
Geoserver REST API ShapeFileDataStore

Geoserver REST API ShapeFileDataStore
}
\examples{
GSShapefileDataStore$new(name = "ds", description = "des",
                         enabled = TRUE, url = "file://data/shape.shp")

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{DataStore}
\keyword{ESRI}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{shapefile}
\section{Super classes}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{\link[geosapi:GSAbstractStore]{geosapi::GSAbstractStore}} -> \code{\link[geosapi:GSAbstractDataStore]{geosapi::GSAbstractDataStore}} -> \code{GSShapefileDataStore}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSShapefileDataStore-new}{\code{GSShapefileDataStore$new()}}
\item \href{#method-GSShapefileDataStore-setUrl}{\code{GSShapefileDataStore$setUrl()}}
\item \href{#method-GSShapefileDataStore-setCharset}{\code{GSShapefileDataStore$setCharset()}}
\item \href{#method-GSShapefileDataStore-setCreateSpatialIndex}{\code{GSShapefileDataStore$setCreateSpatialIndex()}}
\item \href{#method-GSShapefileDataStore-setMemoryMappedBuffer}{\code{GSShapefileDataStore$setMemoryMappedBuffer()}}
\item \href{#method-GSShapefileDataStore-setCacheReuseMemoryMaps}{\code{GSShapefileDataStore$setCacheReuseMemoryMaps()}}
\item \href{#method-GSShapefileDataStore-setDefautConnectionParameters}{\code{GSShapefileDataStore$setDefautConnectionParameters()}}
\item \href{#method-GSShapefileDataStore-clone}{\code{GSShapefileDataStore$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="getClassName"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-getClassName'><code>geosapi::GSRESTResource$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="print"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-print'><code>geosapi::GSRESTResource$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setDescription"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setDescription'><code>geosapi::GSAbstractStore$setDescription()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setEnabled"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setEnabled'><code>geosapi::GSAbstractStore$setEnabled()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setType"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setType'><code>geosapi::GSAbstractStore$setType()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="addConnectionParameter"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-addConnectionParameter'><code>geosapi::GSAbstractDataStore$addConnectionParameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="decode"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-decode'><code>geosapi::GSAbstractDataStore$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="delConnectionParameter"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-delConnectionParameter'><code>geosapi::GSAbstractDataStore$delConnectionParameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="setConnectionParameter"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-setConnectionParameter'><code>geosapi::GSAbstractDataStore$setConnectionParameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="setConnectionParameters"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-setConnectionParameters'><code>geosapi::GSAbstractDataStore$setConnectionParameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDataStore-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDataStore-new}{}}}
\subsection{Method \code{new()}}{
initializes a shapefile data store
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDataStore$new(
  xml = NULL,
  name = NULL,
  description = "",
  enabled = TRUE,
  url
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{an object of class \link[xml2]{xml_node-class} to create object from XML}

\item{\code{name}}{coverage store name}

\item{\code{description}}{coverage store description}

\item{\code{enabled}}{whether the store should be enabled or not. Default is \code{TRUE}}

\item{\code{url}}{url}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDataStore-setUrl"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDataStore-setUrl}{}}}
\subsection{Method \code{setUrl()}}{
Set the spatial files data URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDataStore$setUrl(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDataStore-setCharset"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDataStore-setCharset}{}}}
\subsection{Method \code{setCharset()}}{
Set the charset used for DBF file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDataStore$setCharset(charset = "ISO-8859-1")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{charset}}{charset. Default value is 'ISO-8859-1'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDataStore-setCreateSpatialIndex"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDataStore-setCreateSpatialIndex}{}}}
\subsection{Method \code{setCreateSpatialIndex()}}{
Set the 'Create Spatial Index' option
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDataStore$setCreateSpatialIndex(create = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{create}}{create. Default is \code{TRUE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDataStore-setMemoryMappedBuffer"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDataStore-setMemoryMappedBuffer}{}}}
\subsection{Method \code{setMemoryMappedBuffer()}}{
Set the 'Memory Mapped Buffer' option
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDataStore$setMemoryMappedBuffer(buffer = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{buffer}}{buffer. Default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDataStore-setCacheReuseMemoryMaps"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDataStore-setCacheReuseMemoryMaps}{}}}
\subsection{Method \code{setCacheReuseMemoryMaps()}}{
Set the 'Cache & Reuse Memory Maps' option.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDataStore$setCacheReuseMemoryMaps(maps = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{maps}}{maps. Default is \code{TRUE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDataStore-setDefautConnectionParameters"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDataStore-setDefautConnectionParameters}{}}}
\subsection{Method \code{setDefautConnectionParameters()}}{
Set default connection parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDataStore$setDefautConnectionParameters()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDataStore-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDataStore-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDataStore$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
