% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_align}
\alias{GC_align}
\title{Align gene clusters}
\usage{
GC_align(GC_chart, id_column, id, align = "left")
}
\arguments{
\item{GC_chart}{A chart object containing genomic data along with clustering
information.}

\item{id_column}{The name of the column that contains the gene identifiers.}

\item{id}{The specific identifier of the gene to be aligned.}

\item{align}{The alignment method for the gene. Valid values are
"left", "right", or "center". Defaults to "left".}
}
\value{
The modified `GC_chart` object with updated genomic coordinates.
}
\description{
This function aligns clusters based on a specified gene id.
}
\examples{
genes_data <- data.frame(
  start = c(10, 90, 130, 170, 210),
  end = c(40, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 2', 'Gene 3', 'Gene 4', 'Gene 5'),
  group = c('A', 'B', 'C', 'C', 'A'),
  cluster =  c(1, 1, 1, 2, 2)
)


GC_chart(genes_data, group = "group", cluster = "cluster", height = "150px") \%>\%
  GC_align("group", "A", align = "left") \%>\%
  GC_legend(FALSE)

}
