% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdl_request.R
\name{gdl_request}
\alias{gdl_request}
\title{Data request function}
\usage{
gdl_request(session)
}
\arguments{
\item{session}{A valid GDL session object to interface with.}
}
\value{
A data frame containing the data returned from the GDL API.
}
\description{
Data request function
}
\examples{
\dontrun{
# Create a session using your API token (provided by environment here)
session <- gdl_session(Sys.getenv('GDL_API_TOKEN'))
# Customize parameters
session <- set_indicator(session, 'iwi')
session <- set_country(session, 'IND')
# Finally, request the data from GDL
iwi_india <- gdl_request(session)
iwi_india[1:5, 3:8]
# (showing only the five rows and columns for illustrative purposes)
}
}
