% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{read_wides}
\alias{read_wides}
\title{Read wides}
\usage{
read_wides(
  files,
  filetype = NULL,
  startrow = NULL,
  endrow = NULL,
  startcol = NULL,
  endcol = NULL,
  header = TRUE,
  sheet = NULL,
  run_names = NULL,
  run_names_header = "file",
  run_names_dot = FALSE,
  run_names_path = TRUE,
  run_names_ext = FALSE,
  metadata = NULL,
  na.strings = c("NA", ""),
  extension,
  names_to_col,
  ...
)
}
\arguments{
\item{files}{A vector of filepaths (relative to current working directory)
where each one is a widemeasures set of data}

\item{filetype}{(optional) the type(s) of the files. Options include:

                 "csv", "xls", or "xlsx".
                 
                 "tbl" or "table" to use \code{read.table} to read the file,
                 "csv2" to use \code{read.csv2}, "delim" to 
                 use \code{read.delim}, or "delim2" to use \code{read.delim2}.
                 
                 If none provided, \code{read_wides} will infer filetype(s) 
                 from the extension(s) in \code{files}. When extension is 
                 not "csv", "xls", or "xlsx", will use "table".}

\item{startrow, endrow, startcol, endcol}{(optional) the rows and columns where 
the data are located in \code{files}.

Can be a vector or list the same length as \code{files}, or
a single value that applies to all \code{files}. Values
can be numeric or a string that will be automatically
converted to numeric by \code{from_excel}.

If not provided, data is presumed to begin on the first
row and column of the file(s) and end on the last row and
column of the file(s).}

\item{header}{logical for whether there is a header in the data. If FALSE
columns are simply numbered. If TRUE, the first row of the
data (\code{startrow} if specified) is used 
as the column names}

\item{sheet}{The sheet of the input files where data is located (if input
files are .xls or .xlsx). If not specified defaults to the first
sheet}

\item{run_names}{Names to give the widemeasures read in. By default uses the
file names if not specified}

\item{run_names_header}{Should the run names (provided in \code{run_names}
or inferred from \code{files}) be added as a column to 
the widemeasures? If \code{run_names_header} is NULL, 
they will not be. If \code{run_names_header} is a string, 
that string will be the column header for the column 
where the names will be stored}

\item{run_names_dot}{If run_names are inferred from filenames, should 
the leading './' (if any) be retained}

\item{run_names_path}{If run_names are inferred from filenames, should 
the path (if any) be retained}

\item{run_names_ext}{If run_names are inferred from filenames, should 
the file extension (if any) be retained}

\item{metadata}{(optional) non-spectrophotometric data that should be 
associated with each read widemeasures. A named list where 
each item in the list is either: a vector of length 2, or
a list containing two vectors. 

In the former case, each vector should provide the row and 
column where the metadata is located in all of the
blockmeasures input files.

In the latter case, the first vector should provide the rows
where the metadata is located in each of the corresponding
input files, and the second vector should provide the 
columns where the metadata is located in each of the
corresponding input files. (This case is typically used 
when reading multiple blocks from a single file.)}

\item{na.strings}{A character vector of strings which are to be interpreted
as \code{NA} values by \code{utils::read.csv},
\code{readxl::read_xls}, \code{readxl::read_xlsx},
or \code{utils::read.table}}

\item{extension}{Allowed for backward compatibility; \code{filetype} is
now the preferred argument name.}

\item{names_to_col}{Allowed for backward compatibility; 
\code{run_names_header} is now the preferred argument name.}

\item{...}{Other arguments passed to \code{utils::read.csv},
\code{readxl::read_xls}, \code{readxl::read_xlsx}, or
\code{utils::read.table}}
}
\value{
A dataframe containing a single widemeasures, or
        A list of widemeasures named by filename
}
\description{
A function that imports widemeasures in files into the R environment
}
\details{
startrow, endrow, startcol, endcol, timecol, sheet and filetype 
can either be a single value that applies for all files or
vectors or lists the same length as \code{files},
}
