% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gators_download.R
\name{gators_download}
\alias{gators_download}
\title{Download - Download specimen data from both iDigBio and GBIF}
\usage{
gators_download(
  synonyms.list,
  write.file = FALSE,
  filename = NA,
  gbif.match = "fuzzy",
  gbif.prov = FALSE,
  idigbio.filter = TRUE,
  limit = 1e+05
)
}
\arguments{
\item{synonyms.list}{A list of scientific names including the accepted scientific name and any synonyms for your desired species. For example, \code{synonyms.list = c("Asclepias curtissii","Asclepias aceratoides", "Asclepias arenicola", "Oxypteryx arenicola", "Oxypteryx curtissii")}.
This parameter is required.}

\item{write.file}{A parameter to choose whether to produce a .csv file containing search results.
This parameter is not required and is assigned FALSE by default.}

\item{filename}{The path and file name for the retrieved data. Note that this parameter should include the ".csv"
extension as well. For example, \code{filename = "base_folder/other_folder/my_file.csv"}. The file path can be entered
either as relative to the current working directory (example: "../my_file.csv") or as a full path. This parameter is
required if \code{write.file = TRUE}.}

\item{gbif.match}{A parameter to select either search by fuzzy matching of scientific name or to search by species code.
For example, \code{gbif.match = "fuzzy"} will search by fuzzy match and \code{gbif.match = "code"} will search by code. This parameter
is not required and is assigned "fuzzy" by default.}

\item{gbif.prov}{A parameter to obtain the provider/verbatim columns from GBIF. This parameter is optional
and is assigned \code{FALSE} by default.}

\item{idigbio.filter}{A parameter to remove less relevant search results from iDigBio. Based on the search input, results may
include data points for a different species that mention the desired species in the locality information, for example.
Choosing \code{idigbio.filter = TRUE} will return the data frame with rows in which the name column fuzzy matches a name on the synonym list.
This parameter is not required and is assigned TRUE by default.}

\item{limit}{Default = 100,000 (maximum). Set limit to the number of records requested for each element in synonyms.list from each aggregator.}
}
\value{
Returns a data frame and writes a csv file as specified in the input.
This csv file will contain search results for the desired species
from the GBIF and iDigBio databases. The columns are as follows:
\itemize{
\item \href{https://dwc.tdwg.org/list/#dwc_scientificName}{scientificName}
\item \href{https://dwc.tdwg.org/list/#dwc_genus}{genus}
\item \href{https://dwc.tdwg.org/list/#dwc_specificEpithet}{specificEpithet}
\item \href{https://dwc.tdwg.org/list/#dwc_infraspecificEpithet}{infraspecificEpithet}
\item ID (contains unique IDs defined from GBIF or iDigBio)
\item \href{https://dwc.tdwg.org/list/#dwc_occurrenceID}{occurrenceID}
\item \href{https://dwc.tdwg.org/list/#dwc_basisOfRecord}{basisOfRecord}
\item \href{https://dwc.tdwg.org/list/#dwc_eventDate}{eventDate}
\item \href{https://dwc.tdwg.org/list/#dwc_year}{year}
\item \href{https://dwc.tdwg.org/list/#dwc_month}{month}
\item \href{https://dwc.tdwg.org/list/#dwc_day}{day}
\item \href{https://dwc.tdwg.org/list/#dwc_institutionCode}{institutionCode}
\item \href{https://dwc.tdwg.org/list/#dwc_recordedBy}{recordedBy}
\item \href{https://dwc.tdwg.org/list/#dwc_informationWithheld}{informationWithheld}
\item \href{https://dwc.tdwg.org/list/#dwc_country}{country}
\item \href{https://dwc.tdwg.org/list/#dwc_county}{county}
\item \href{https://dwc.tdwg.org/list/#dwc_stateProvince}{stateProvince}
\item \href{https://dwc.tdwg.org/list/#dwc_locality}{locality}
\item \href{https://dwc.tdwg.org/list/#dwc_decimalLatitude}{latitude}
\item \href{https://dwc.tdwg.org/list/#dwc_decimalLongitude}{longitude}
\item \href{https://dwc.tdwg.org/list/#dwc_coordinateUncertaintyInMeters}{coordinateUncertaintyInMeters}
\item \href{https://dwc.tdwg.org/list/#dwc_habitat}{habitat}
\item aggregator (either GBIF or iDigBio)
}
}
\description{
The \code{gators_download()} function downloads data from GBIF and iDigBio for your desired species.
}
\details{
With \code{gators_download()} you can obtain biodiversity records for your species of interest from both GBIF and iDigBio.
This function is innovative in how it searches iDigBio. Unlike \code{spocc::occ()}, we do not query the iDigBio API using
the scientific name field, as this will only return exact matches.
Instead, we designed a “pseudo-fuzzy match” to search all fields for
partial matches to the supplied scientific names.
This function uses the \code{get_idigbio()}, \code{get_gbif()}, \code{fix_columns()}, \code{fix_names()}, and \code{filter_fix_names()} functions.
This function requires packages magrittr, rgbif, dplyr, ridigbio, and stringr.
}
\examples{
df <- gators_download(synonyms.list = c("Galax urceolata", "Galax aphylla"), limit = 10)
df <- gators_download(synonyms.list = "Galax urceolata", gbif.match = "code",
idigbio.filter = FALSE, limit = 10)

}
