% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials_app_default.R
\name{credentials_app_default}
\alias{credentials_app_default}
\title{Load Application Default Credentials}
\usage{
credentials_app_default(scopes = NULL, ..., subject = NULL)
}
\arguments{
\item{scopes}{A character vector of scopes to request. Pick from those listed
at \url{https://developers.google.com/identity/protocols/oauth2/scopes}.

For certain token flows, the
\code{"https://www.googleapis.com/auth/userinfo.email"} scope is unconditionally
included. This grants permission to retrieve the email address associated
with a token; gargle uses this to index cached OAuth tokens. This grants no
permission to view or send email and is generally considered a low-value
scope.}

\item{...}{Additional arguments passed to all credential functions.}

\item{subject}{An optional subject claim. Specify this if you wish to use the
service account represented by \code{path} to impersonate the \code{subject}, who is
a normal user. Before this can work, an administrator must grant the service
account domain-wide authority. Identify the user to impersonate via their
email, e.g. \code{subject = "user@example.com"}. Note that gargle automatically
adds the non-sensitive \code{"https://www.googleapis.com/auth/userinfo.email"}
scope, so this scope must be enabled for the service account, along with
any other \code{scopes} being requested.}
}
\value{
An \code{\link[httr:Token-class]{httr::TokenServiceAccount}}, a \code{\link{WifToken}},
an \code{\link[httr:Token-class]{httr::Token2.0}} or \code{NULL}.
}
\description{
Loads credentials from a file identified via a search strategy known as
Application Default Credentials (ADC). The hope is to make auth "just work"
for someone working on Google-provided infrastructure or who has used Google
tooling to get started, such as the \href{https://cloud.google.com/sdk/gcloud}{\code{gcloud} command line tool}.

A sequence of paths is consulted, which we describe here, with some abuse of
notation. ALL_CAPS represents the value of an environment variable and \verb{\%||\%}
is used in the spirit of a \href{https://en.wikipedia.org/wiki/Null_coalescing_operator}{null coalescing operator}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{GOOGLE_APPLICATION_CREDENTIALS
CLOUDSDK_CONFIG/application_default_credentials.json
# on Windows:
(APPDATA \%||\% SystemDrive \%||\% C:)\\gcloud\\application_default_credentials.json
# on not-Windows:
~/.config/gcloud/application_default_credentials.json
}\if{html}{\out{</div>}}

If the above search successfully identifies a JSON file, it is parsed and
ingested as a service account, an external account ("workload identity
federation"), or a user account. Literally, if the JSON describes a service
account, we call \code{\link[=credentials_service_account]{credentials_service_account()}} and if it describes an
external account, we call \code{\link[=credentials_external_account]{credentials_external_account()}}.
}
\examples{
\dontrun{
credentials_app_default()
}
}
\seealso{
\itemize{
\item \url{https://cloud.google.com/docs/authentication#adc}
\item \url{https://cloud.google.com/sdk/docs/}
}

Other credential functions: 
\code{\link{credentials_byo_oauth2}()},
\code{\link{credentials_external_account}()},
\code{\link{credentials_gce}()},
\code{\link{credentials_service_account}()},
\code{\link{credentials_user_oauth2}()},
\code{\link{token_fetch}()}
}
\concept{credential functions}
