% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammaFuncModel.R
\name{generate_models}
\alias{generate_models}
\title{Function that produces a fitted gamma model for each metabolite}
\usage{
generate_models(
  df,
  met_vec,
  covariates,
  time_terms = c("Time", "log(Time)"),
  grp_name = "Diet",
  random_formula = ~1 + Time | ID/Diet,
  correlation_formula = corSymm(form = ~Time | ID/Diet),
  weights = varIdent(form = ~1 | Time),
  graph = "None",
  save_path = NULL
)
}
\arguments{
\item{df}{Data frame containing columns Group(factor); ID(subject ID: character); Time(positive: numeric); other Time terms (numeric); other individidual characteristics covariates; as well columns of metabolite concentrations}

\item{met_vec}{the vector of metabolite names}

\item{covariates}{Vector containing the names of the "ID" covariate, grouping covariate and other covariates excluding any "Time" covariates}

\item{time_terms}{is the vector that contains all additional form of the covariate 'Time" (including the 'Time' covariate), and must contain 'log(Time)', other forms also include I(Time^2) and I(Time^3);}

\item{grp_name}{is the grouping variable;}

\item{random_formula}{is the random effects formula for the model, nested effects of Diet within ID (could also add random slope for 'Time');}

\item{correlation_formula}{is the correlation formula. Default is autorgressive but can accommodate other forms such as unstructured covariance or exponential covariance;}

\item{weights}{specify a variance function that models heteroscedasticity;}

\item{graph}{character string, 'None' by default. If not 'None, in addition to returning models, produces pdf file of graphs based on the specific value of 'graph'.}

\item{save_path}{location where the pdf file will be saved; default is NULL, i.e. pdf is saved to a temporary location}
}
\value{
List that contains fitted models for each metabolite and a pdf file for fitted concenration curves.
}
\description{
Function that produces a fitted gamma model for each metabolite
}
\examples{
\donttest{
require(gammaFuncModel)
require(dplyr)
require(nlme)
 df <- data.frame(
  ID = rep(sprintf("\%02d", 1:10), each = 9 * 3),  
  Time = rep(rep(1:9, each = 3), 10),             
  Diet = as.factor(rep(1:3, times = 9 * 10)),     
  Age = rep(sample(20:70, 10, replace = TRUE), each = 9 * 3), 
  BMI = round(rep(runif(10, 18.5, 35), each = 9 * 3), 1)     
)
metvar <- paste0("met", 1:10)
concentration_data <- replicate(10, round(runif(270, 5, 15), 2))
colnames(concentration_data) <- metvar[1:10]
df <- cbind(df, as.data.frame(concentration_data))
covariates <- c("ID", "Diet", "Age", "BMI")
mods <- generate_models(
  df = df, 
 met_vec = metvar, 
  covariates = covariates, 
  graph = 'None', 
  save_path = NULL)
}
}
\references{
Wickham, H. (2022). dplyr: A Grammar of Data Manipulation. R package version 1.0.10. 
Available at: \url{https://CRAN.R-project.org/package=dplyr}

Pinheiro, J. C., & Bates, D. M. (2022). nlme: Linear and Nonlinear Mixed Effects Models. R package version 3.1-153.
Available at: \url{https://CRAN.R-project.org/package=nlme}
}
