% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{saveView}
\alias{saveView}
\title{Help function to save the view angle for the RGL 3D plot}
\usage{
saveView(fname = "view.RData", overwrite = FALSE, print = FALSE)
}
\arguments{
\item{fname}{The file name of the view.}

\item{overwrite}{Overwrite existing file.}

\item{print}{Print the view so can be copied to R code (no file is saved).}
}
\value{
NULL (invisible).
}
\description{
Help function to save the view angle for the RGL 3D plot
}
\note{
Only save if the file name don't exists.
}
\examples{
\donttest{
view <- matrix( c(-0.412063330411911, -0.228006735444069, 0.882166087627411, 0,
0.910147845745087, -0.0574885793030262, 0.410274744033813, 0, -0.042830865830183,
0.97196090221405, 0.231208890676498, 0, 0, 0, 0, 1), nc = 4)

loadView(v = view)
A <- matrix( c(3, 2, 5, 2, 1, 1, 1, 1, 3, 5, 2, 4), nc = 3, byrow = TRUE)
b <- c(55, 26, 30, 57)
obj <- c(20, 10, 15)
plotPolytope(A, b, plotOptimum = TRUE, obj = obj, labels = "coord")

# Try to modify the angle in the RGL window
saveView(print = TRUE)  # get the view angle to insert into R code
}
}
\author{
Lars Relund \email{lars@relund.dk}
}
