% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.funspace.R
\name{summary.funspace}
\alias{summary.funspace}
\title{Summarizing Functional Spaces}
\usage{
\method{summary}{funspace}(object, ...)
}
\arguments{
\item{object}{A \code{funspace} object produced by \code{funspace()},
\code{funspaceGAM()}, or \code{funspaceNull()}.}

\item{...}{Other arguments}
}
\value{
No return value. This function is called for its side effect: summarizing objects of class \code{"funspace"}.
}
\description{
\code{summary} method for class \code{funspace}"
}
\details{
Produces default summary. If the input object was generated with \code{funspace()}, the summary includes information about the characteristics of the functional space (particularly if it derives from a PCA), along with functional diversity indicators (functional richness and functional divergence) for the whole set of observations and for each group (in case groups are specified). If the input object was generated with \code{funspaceGAM()}, the function returns the summary for the GAM models for the whole set of observations and individual groups. If the input was generated  with \code{funspaceNull()}, the function returns tests exploring the difference between the observed functional richness and the null model functional richness.
}
\examples{
x <- princomp(GSPFF)
funtest <- funspace(x = x, PCs = c(1, 2), threshold = 0.95)
summary(funtest)


}
