% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile.R
\name{tile}
\alias{tile}
\title{Split a raster into tiles}
\usage{
tile(x, nx, ny, filename = "", suffix = NULL, ...)
}
\arguments{
\item{x}{Raster* object to split}

\item{nx}{Number of horizontal cells in the splitting grid}

\item{ny}{Number of vertical cells in the splitting grid}

\item{filename}{Character. Output file name including path to directory and
eventually extension.Default is \code{""} (output not written to disk).}

\item{suffix}{Character appended to filename to differentiate tiles
(must have length nx x ny). If left NULL, tiles will be numbered by columns
and rows}

\item{...}{Additional parameters passed to \code{\link[raster]{writeRaster}}}
}
\value{
A list of Raster* objects
}
\description{
This function is used to split a raster into smaller tiles. The raster is
split in a grid pattern with \code{nx} columns and \code{ny} rows.
}
\examples{
# Load raster package
library(raster)

elev_p95 <- stack(system.file("extdata/examples/ALS_metrics_p95.tif",package="foster"))

# Split elev_p95 into a 1 x 2 grid
tile(elev_p95, nx = 1, ny = 2)
}
\seealso{
\code{\link[raster]{crop}}
}
