% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.R
\name{accuracy}
\alias{accuracy}
\title{Calculate accuracy metrics}
\usage{
accuracy(obs, preds, vars = NULL, folds = NULL)
}
\arguments{
\item{obs}{A vector of observed values}

\item{preds}{A vector of predicted values}

\item{vars}{Optional vector indicating different variables}

\item{folds}{Optional vector indicating the folds}
}
\value{
Data frame with following columns: \describe{
  \item{\code{vars}}{Response variable}
  \item{\code{R2}}{R2}
  \item{\code{RMSE}}{RMSE}
  \item{\code{RMSE_rel}}{Relative RMSE }
  \item{\code{bias}}{bias}
  \item{\code{bias_rel}}{Relative bias}
  \item{\code{count}}{Number of observations}}
}
\description{
Calculate coefficient of determination (R2), root-mean square error (RMSE) and bias between predictions and observations of continuous variables.
}
\details{
R2 is calculated with the following formula:
\deqn{R^{2} = 1 - \frac{\sum (y_{i} - \hat{y}_{i})^{2}}{\sum (y_{i} - \bar{y}_{i})^{2}}}

RMSE is calculated with the following formula:
\deqn{RMSE = \sqrt{\frac{1}{n} \sum (\hat{y}_{i} - y_{i})^{2}}}

Bias is calculated with the following formula:
\deqn{Bias = \frac{\sum (\hat{y}_{i} - y_{i})}{n}}

Relative RMSE and bias are also calculated by dividing their value by the mean of observations.

If accuracy assessment was performed using k-fold cross-validation the accuracy metrics are calculated for each fold separately. The mean value of the accuracy metrics across all folds is also returned.
}
\examples{
# kNN_preds is a data frame obtained from foster::trainNN
# It contains predictions and observations of the trained kNN model
load(system.file("extdata/examples/kNN_preds.RData",package="foster"))

accuracy(obs = kNN_preds$obs,
         preds = kNN_preds$preds,
         vars = kNN_preds$variable,
         folds = kNN_preds$Fold)
}
