% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_ae_forestly.R
\name{format_ae_forestly}
\alias{format_ae_forestly}
\title{Format outdata for interactive forest plot}
\usage{
format_ae_forestly(
  outdata,
  display = c("n", "prop", "fig_prop", "fig_diff"),
  digits = 1,
  width_term = 200,
  width_fig = 320,
  width_n = 40,
  width_prop = 60,
  width_diff = 80,
  footer_space = 90,
  color = NULL,
  diff_label = "Treatment <- Favor -> Placebo",
  show_ae_parameter = FALSE
)
}
\arguments{
\item{outdata}{An \code{outdata} object created by \code{\link[=prepare_ae_forestly]{prepare_ae_forestly()}}.}

\item{display}{A character vector of measurement to be displayed.
\itemize{
\item \code{n}: Number of subjects with AE.
\item \code{prop}: Proportion of subjects with AE.
\item \code{total}: Total columns.
\item \code{diff}: Risk difference.
}}

\item{digits}{A value of digits to be displayed for proportion and
risk difference.}

\item{width_term}{Width in px for AE term column.}

\item{width_fig}{Width in px for proportion and risk difference figure.}

\item{width_n}{Width in px for "N" columns.}

\item{width_prop}{Width in px for "(\%)" columns.}

\item{width_diff}{Width in px for risk difference columns.}

\item{footer_space}{Space in px for footer to display legend.}

\item{color}{A vector of colors for analysis groups.
Default value supports up to 4 groups.}

\item{diff_label}{x-axis label for risk difference.}

\item{show_ae_parameter}{A boolean value to display AE parameter column.}
}
\value{
An \code{outdata} object.
}
\description{
Format outdata for interactive forest plot
}
\examples{
adsl <- forestly_adsl[1:100,]
adae <- forestly_adae[1:100,]
meta_forestly(
  dataset_adsl = adsl,
  dataset_adae = adae
) |>
  prepare_ae_forestly()|>
  format_ae_forestly()
}
