% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt.R
\name{as.data.frame.fmt}
\alias{as.data.frame.fmt}
\title{Casts a format to a data frame}
\usage{
\method{as.data.frame}{fmt}(
  x,
  row.names = NULL,
  optional = FALSE,
  ...,
  name = deparse(substitute(x, env = environment()))
)
}
\arguments{
\item{x}{An object of class "fmt".}

\item{row.names}{Row names of the return data frame.  Default is NULL.}

\item{optional}{TRUE or FALSE value indicating whether converting to
syntactic variable names is options.  In the case of formats, the 
resulting data frame will always be returned with syntactic names, and 
this parameter is ignored.}

\item{...}{Any follow-on parameters.}

\item{name}{An optional name for the format.  By default, the name of 
the variable holding the format will be used.}
}
\description{
Cast a format object to a data frame.  This function is
a class-specific implementation of the the generic \code{as.data.frame} 
method.
}
\seealso{
Other fmt: 
\code{\link{as.fmt}()},
\code{\link{as.fmt.data.frame}()},
\code{\link{condition}()},
\code{\link{is.format}()},
\code{\link{labels.fmt}()},
\code{\link{print.fmt}()},
\code{\link{value}()}
}
\concept{fmt}
