% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acorr.R
\name{acorr_diagnostics}
\alias{acorr_diagnostics}
\title{Autocorrelation diagnostics for residuals}
\usage{
acorr_diagnostics(
  resid,
  runs = NULL,
  max_lag = 20L,
  aggregate = c("mean", "median", "none")
)
}
\arguments{
\item{resid}{Numeric matrix (time x voxels), typically whitened residuals.}

\item{runs}{Optional run labels.}

\item{max_lag}{Maximum lag to evaluate.}

\item{aggregate}{Aggregation across voxels: "mean", "median", or "none".}
}
\value{
List of autocorrelation values and nominal confidence interval.
}
\description{
Autocorrelation diagnostics for residuals
}
\examples{
# Generate example residuals with some autocorrelation
n_time <- 200
n_voxels <- 50
resid <- matrix(rnorm(n_time * n_voxels), n_time, n_voxels)

# Add some AR(1) structure
for (v in 1:n_voxels) {
  resid[, v] <- filter(resid[, v], filter = 0.3, method = "recursive")
}

# Check autocorrelation
acorr_check <- acorr_diagnostics(resid, max_lag = 10, aggregate = "mean")

# Examine lag-1 autocorrelation
lag1_acorr <- acorr_check$acf[2]  # First element is lag-0 (always 1)
}
