% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ffi_hm1981}
\alias{ffi_hm1981}
\title{Compute flux using nonlinear Hutchinson and Mosier (1981) model}
\usage{
ffi_hm1981(time, conc, h = 1)
}
\arguments{
\item{time}{Time values, numeric}

\item{conc}{Gas concentration values, numeric}

\item{h}{Effective chamber height}
}
\value{
Flux estimate; see references for more information.
}
\description{
Compute flux using nonlinear Hutchinson and Mosier (1981) model
}
\examples{
# If data are approximately linear, then NA is returned
ffi_hm1981(cars$speed, cars$dist)
# If data are nonlinear (saturating) then flux based on gas diffusion theory
ffi_hm1981(Puromycin$conc, Puromycin$rate)
}
\references{
Hutchinson, G. L. and Mosier, A. R.: Improved soil cover method for field
measurement of nitrous oxide fluxes, Soil Sci. Soc. Am. J., 45, 311-316,
1981. \doi{10.2136/sssaj1981.03615995004500020017x}
}
