% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flipscores-package.R, R/flipscores_package.R
\docType{package}
\name{flipscores-package}
\alias{flipscores-package}
\title{flipscores: Robust Score Testing in GLMs, by Sign-Flip Contributions}
\description{
Provides robust tests for testing in GLMs, by sign-flipping score contributions. The tests are robust against overdispersion, heteroscedasticity and, in some cases, ignored nuisance variables. See Hemerik, Goeman and Finos (2020) \doi{10.1111/rssb.12369}.

It provides robust tests for testing in GLMs, by sign-flipping score contributions. The tests are often robust against overdispersion, heteroscedasticity and, in some cases, ignored nuisance variables.
}
\examples{
set.seed(1)
dt=data.frame(X=rnorm(20),
   Z=factor(rep(LETTERS[1:3],length.out=20)))
dt$Y=rpois(n=20,lambda=exp(dt$X))
mod=flipscores(Y~Z+X,data=dt,family="poisson",x=TRUE)
summary(mod)

# Anova test
anova(mod)
# or
mod0=flipscores(Y~Z,data=dt,family="poisson",x=TRUE)
anova(mod0,mod)
# and
mod0=flipscores(Y~X,data=dt,family="poisson")
anova(mod0,mod)

}
\author{
\strong{Maintainer}: Livio Finos \email{livio.finos@unipd.it} (\href{https://orcid.org/0000-0003-3181-8078}{ORCID})

Other contributors:
\itemize{
  \item Jelle J. Goeman [contributor]
  \item Jesse Hemerik [contributor]
  \item Riccardo De Santis [contributor]
}


Livio Finos, Jelle Goeman and Jesse Hemerik, with contribution of Riccardo De Santis.
}
\keyword{internal}
