% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-GHSLdata.R
\name{download_GHSLdata}
\alias{download_GHSLdata}
\title{Download data products from the GHSL website}
\usage{
download_GHSLdata(
  output_directory,
  filenames,
  products = c("BUILT_S", "POP", "LAND"),
  epoch = 2020,
  release = "R2023A",
  crs = 54009,
  resolution = 1000,
  version = c("V1", "0"),
  extent = "global"
)
}
\arguments{
\item{output_directory}{character. Path to the output directory}

\item{filenames}{character. Filenames for the output files}

\item{products}{vector with the types of the data products: \code{"BUILT_S"}, \code{"POP"} and/or \code{"LAND"} for the built-up area grid, the population grid and the land grid respectively}

\item{epoch}{integer. Epoch}

\item{release}{character. Release code (only release \code{"R2022A"} and \code{"R2023A"} are supported)}

\item{crs}{integer. EPSG code of the coordinate system: for example, \code{54009} for Mollweide.}

\item{resolution}{integer. Resolution (in meters for Mollweide projection).}

\item{version}{vector with the version code and number}

\item{extent}{character or vector representing the spatial extent. There are three possibilities:
\itemize{
\item \code{extent = "global"}: The data is downloaded on a global scale.
\item \code{extent} is a vector of GHSL tile ids: The data is downloaded for each tile separately and afterwards merged together. For more information about the GHSL tiles and their extent see \code{\link{GHSL_tiles}} or \href{https://ghsl.jrc.ec.europa.eu/download.php}{GHSL Download page}.
\item \code{extent = "regions"}: The data will be downloaded in 9 pre-defined regions. The pre-defined regions are the smallest grouping of GHSL tiles possible while ensuring that no continuous land mass is split over two regions. The regions are constructed to execute the Degree of Urbanisation classification algorithms in a memory-efficient manner. For each of the regions, the data products will be downloaded and saved in a sub-directory of \code{output_directory} (e.g., for region \code{W_AME}, the directory \code{output_directory/W_AME} is created). For more information, see the documentation of \code{\link{GHSL_tiles_per_region}}.
}}
}
\value{
path to the created files.
}
\description{
The function will download data products with certain specifications from the Global Human Settlement Layer (GHSL) website. The following data products are supported:
\itemize{
\item \strong{BUILT_S}: the built-up area grid
\item \strong{POP}: the population grid
\item \strong{LAND}: the land grid (with the proportion of permanent land)
}

These are also the three data products that are required for the grid cell classification of the Degree of Urbanisation. For more information about the data products and their available specifications, see \href{https://ghsl.jrc.ec.europa.eu/download.php}{GHSL Download page}. The downloaded data will be saved in the \code{output_directory} together with a JSON metadata-file. This function downloads large volumes of data, make sure the timeout parameter is sufficiently high (for example: \code{options(timeout=500)}).

\emph{Note that the land grid is only available for epoch 2018 and release R2022A on the GHSL website. The land grid will consequently always be downloaded with these specifications, regardless of the epoch and release specified in the arguments (a warning message is printed).}
}
\examples{
\donttest{
# Download the population grid for epoch 2000 for specific tiles
download_GHSLdata(
  output_directory = tempdir(),
  filename = "POP_2000.tif",
  products = "POP",
  extent = c("R3_C19", "R4_C19"),
  epoch = 2000,
)
\dontshow{
 unlink(file.path(tempdir(), 'POP_2000.tif'))
 unlink(file.path(tempdir(), 'POP_2000.json'))
}
}
}
